'use strict'

entityRegistry['module']['orbitCam'] = {
    extendedInfo: {
        displayName: 'Orbit Cam',
        displayGroup: 'Core',
    },
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'distance', displayName: 'Distance', type: 'float', defaultValue: 70 },
        { paramName: 'roll', displayName: 'Roll', type: 'angle', defaultValue: 0 },
        { paramName: 'height', displayName: 'Height', type: 'float', defaultValue: 0 },
        { paramName: 'rotation', displayName: 'Rotation', type: 'angle', defaultValue: 0 },
        { paramName: 'fov', displayName: 'Field of view', type: 'angle', defaultValue: 90 },
        { paramName: 'lookAt', displayName: 'Look At', type: 'float3', defaultValue: [0, 0, 0] },
        { paramName: 'origin', displayName: 'Origin', type: 'float2', defaultValue: [0, 0] },
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                distance,
                roll,
                height,
                rotation,
                fov,
                lookAt,
                origin,
            } = { ...config }
    
            const camera = m4.lookAt([lookAt[0] + Math.sin(rotation) * distance, lookAt[1] - height, lookAt[2] + Math.cos(rotation) * distance], lookAt, [0, 1, 0])
            const rollMat = m4.zRotation(roll)
            const view = m4.multiply(rollMat, m4.inverse(camera))
            const perspective = m4.perspective(fov, renderer.bufferWidth/renderer.bufferHeight, 1, 20)
            camViewPersp = m4.multiply(perspective, view)
            renderer.setOrigin(origin)
        }
    }
}
